import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:intl/intl.dart' as intl;
import 'package:viserpay/data/model/kyc/kyc_response_model.dart';
import '../../view/components/snack_bar/show_custom_snackbar.dart';
import 'my_strings.dart';

class MyUtils {
  static void vibrate() {
    HapticFeedback.heavyImpact();
    HapticFeedback.vibrate();
  }

  static splashScreen() {
    SystemChrome.setSystemUIOverlayStyle(SystemUiOverlayStyle(statusBarColor: MyColor.getPrimaryColor(), statusBarIconBrightness: Brightness.light, systemNavigationBarColor: MyColor.getPrimaryColor(), systemNavigationBarIconBrightness: Brightness.light));
  }

  static allScreen() {
    SystemChrome.setSystemUIOverlayStyle(
      const SystemUiOverlayStyle(
        statusBarColor: MyColor.colorWhite,
        statusBarIconBrightness: Brightness.dark,
        systemNavigationBarColor: MyColor.screenBgColor,
        systemNavigationBarIconBrightness: Brightness.dark,
      ),
    );
  }

  static SystemUiOverlayStyle systemUiOverlayStyle = const SystemUiOverlayStyle(statusBarColor: MyColor.colorWhite, statusBarIconBrightness: Brightness.dark, systemNavigationBarColor: MyColor.colorWhite, systemNavigationBarIconBrightness: Brightness.dark);

  static dynamic getShadow() {
    return [
      BoxShadow(blurRadius: 15.0, offset: const Offset(0, 25), color: Colors.grey.shade500.withValues(alpha: 0.6), spreadRadius: -35.0),
    ];
  }

  static dynamic getShadow2({double blurRadius = 8}) {
    return [
      BoxShadow(
        color: MyColor.getShadowColor().withValues(alpha: 0.3),
        blurRadius: blurRadius,
        spreadRadius: 3,
        offset: const Offset(0, 10),
      ),
      BoxShadow(
        color: MyColor.getShadowColor().withValues(alpha: 0.3),
        spreadRadius: 1,
        blurRadius: blurRadius,
        offset: const Offset(0, 1),
      ),
    ];
  }

  static dynamic getBottomSheetShadow() {
    return [
      BoxShadow(
        color: Colors.grey.shade400.withValues(alpha: 0.08),
        spreadRadius: 3,
        blurRadius: 4,
        offset: const Offset(0, 3),
      ),
    ];
  }

  static bool isDirectionRTL(BuildContext context) {
    return intl.Bidi.isRtlLanguage(Localizations.localeOf(context).languageCode);
  }

  static dynamic getCardShadow() {
    return [
      BoxShadow(
        color: Colors.grey.shade400.withValues(alpha: 0.05),
        spreadRadius: 2,
        blurRadius: 2,
        offset: const Offset(0, 3),
      ),
    ];
  }

  static getOperationTitle(String value) {
    String number = value;
    RegExp regExp = RegExp(r'^(\d+)(\w+)$');
    Match? match = regExp.firstMatch(number);
    if (match != null) {
      String? num = match.group(1) ?? '';
      String? unit = match.group(2) ?? '';
      String title = '${MyStrings.last.tr} $num ${unit.capitalizeFirst}';
      return title.tr;
    } else {
      return value.tr;
    }
  }

  static String getChargeText(String charge) {
    String chargeText = "${MyStrings.inc.tr} $charge ${MyStrings.charge.tr}";
    return chargeText;
  }

  String maskSensitiveInformation(String input) {
    if (input.isEmpty) {
      return '';
    }

    final int maskLength = input.length ~/ 2; // Mask half of the characters.

    final String mask = '*' * maskLength;

    final String maskedInput = maskLength > 4 ? input.replaceRange(5, maskLength, mask) : input.replaceRange(0, maskLength, mask);

    return maskedInput;
  }

  static List<FormModel> dynamicFormSelectValueFormatter(List<FormModel>? dynamicFormList) {
    List<FormModel> mainFormList = [];

    if (dynamicFormList != null && dynamicFormList.isNotEmpty) {
      mainFormList.clear();

      for (var element in dynamicFormList) {
        if (element.type == 'select') {
          bool? isEmpty = element.options?.isEmpty;
          bool empty = isEmpty ?? true;
          if (element.options != null && empty != true) {
            if (!element.options!.contains(MyStrings.selectOne)) {
              element.options?.insert(0, MyStrings.selectOne);
            }

            element.selectedValue = element.options?.first;
            mainFormList.add(element);
          }
        } else {
          mainFormList.add(element);
        }
      }
    }
    return mainFormList;
  }

  bool validatePinCode(String pin) {
    if (pin.length < 4) {
      MyUtils.vibrate();
      CustomSnackBar.error(errorList: [MyStrings.pinLengthErrorMessage]);
      return false;
    }
    if (pin.isEmpty) {
      MyUtils.vibrate();
      CustomSnackBar.error(errorList: [MyStrings.pinErrorMessage]);
      return false;
    }

    return true;
  }

  bool balanceValidation({
    required double currentBalance,
    required double amount,
  }) {
    print('available balance: $currentBalance  $amount');

    try {
      // Check if amount is an integer
      if (amount > 0) {
        // It's a valid double or int
        if (amount > currentBalance) {
          CustomSnackBar.error(errorList: [MyStrings.yourBalanceIsLow]);
          return false;
        } else {
          return true;
        }
      } else {
        CustomSnackBar.error(errorList: [MyStrings.enterValidAmount]);
        return false;
      }
    } catch (e) {
      CustomSnackBar.error(errorList: [MyStrings.enterValidAmount]);
      return false;
    }
  }

//permissons
  Future<PermissionStatus> isCameraPermissionGranted() async {
    if (await Permission.camera.isGranted) {
      return PermissionStatus.granted;
    } else {
      await Permission.camera.request().then((value) {
        return value;
      });
      return await Permission.camera.status;
    }
  }

  //
  static List<Widget> makeSloteWidget({required List<Widget> widgets, bool showMoreWidget = false}) {
    List<Widget> pairs = [];
    for (int i = 0; i < (showMoreWidget ? widgets.length : (widgets.length / 2)); i += 4) {
      Widget first = widgets[i];
      Widget? second = (i + 1 < widgets.length) ? widgets[i + 1] : const SizedBox();
      Widget? thrd = (i + 2 < widgets.length) ? widgets[i + 2] : const SizedBox();
      Widget? four = (i + 3 < widgets.length) ? widgets[i + 3] : const SizedBox();

      pairs.add(
        Column(
          children: [
            IntrinsicHeight(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Expanded(child: first),
                  const SizedBox(width: Dimensions.space15),
                  Expanded(child: second),
                  const SizedBox(width: Dimensions.space15),
                  Expanded(child: thrd),
                  const SizedBox(width: Dimensions.space15),
                  Expanded(child: four),
                ],
              ),
            ),
            const SizedBox(height: Dimensions.space25 - 1)
          ],
        ),
      );
    }

    return pairs;
  }

  static List<Widget> removeWidget({required List<Widget> widgets, bool showMoreWidget = false}) {
    List<Widget> pairs = [];
    for (int i = 0; i < (showMoreWidget ? widgets.length : (widgets.length / 3)); i += 4) {
      Widget first = widgets[i];
      Widget? second = (i + 1 < widgets.length) ? widgets[i + 1] : const SizedBox();
      Widget? thrd = (i + 2 < widgets.length) ? widgets[i + 2] : const SizedBox();
      Widget? four = (i + 3 < widgets.length) ? widgets[i + 3] : const SizedBox();

      pairs.add(
        Column(
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Expanded(child: first),
                const SizedBox(width: Dimensions.space15),
                Expanded(child: second),
                const SizedBox(width: Dimensions.space15),
                Expanded(child: thrd),
                const SizedBox(width: Dimensions.space15),
                Expanded(child: four),
              ],
            ),
            const SizedBox(height: Dimensions.space25 - 1)
          ],
        ),
      );
    }

    return pairs;
  }

  static TextInputType getInputTextFieldType(String type) {
    if (type == "email") {
      return TextInputType.emailAddress;
    } else if (type == "number") {
      return TextInputType.number;
    } else if (type == "url") {
      return TextInputType.url;
    }
    return TextInputType.text;
  }

  static bool getTextInputType(String type) {
    if (type == "text") {
      return true;
    } else if (type == "email") {
      return true;
    } else if (type == "number") {
      return true;
    } else if (type == "url") {
      return true;
    } else if (type == "textarea") {
      return true;
    }
    return false;
  }
}

void printX(Object? object) {
  if (kDebugMode) {
    print(object);
  }
}
